<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 4:40 PM
 */

namespace Visionware\DataManager;

class ImportStagingSchemaCreator extends SchemaCreator {
    private $ignore_columns;

    public function __construct($definition, $drops) {
        parent::__construct($definition, $drops);
        $this->ignore_columns = [];
    }

//    protected function process_table($table) {
//        foreach ($table['indices'] as $index) {
//            if (isset($index['import_join_columns'])) {
//                foreach ($index['import_join_columns'] as $import_join_column) {
//                    $this->ignore_columns[] = $import_join_column['foreign'];
//                }
//            }
//        }
//        return $table;
//    }

    protected function process_column($column) {
        if (in_array($column['name'], $this->ignore_columns)) return false;

        return $column;
    }

    protected function process_index($index) {
        if (isset($index['foreign_table'])) {
            $index['name'] = "foreign_$index[name]";
                $index['columns'] = [];
                foreach ($index['import_join_columns'] as $import_join_column) {
                    $index['columns'][$import_join_column['local']]['name'] = $import_join_column['local'];
                    $index['columns'][$import_join_column['local']]['sequence'] = $import_join_column['sequence'];
                }
        }
        return $index;
    }
    protected function statement_create_staging($table, $columns_string, $indices_string, $drops) {
        $sql = [];
        if ($drops) $sql[] = "DROP TABLE IF EXISTS `{$table}_staging`;";

        $sql[] = <<<SQL
CREATE TABLE `{$table}_staging` (
  $columns_string,
  $indices_string
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQL;
        return $sql;
    }

//    protected function build_indices($table) {
//        $indices = [];
//        foreach ($table['indices'] as $index) {
//            $index_string = '';
//            if ($index['name'] == 'PRIMARY') {
//                $index_string = 'PRIMARY ';
//                $index['name'] = '';
//            } else if ($index['name'] == 'unique_key') {
//                $index['name'] = " `$index[name]`";
//                if ($index['unique']) $index_string .= 'UNIQUE ';
//            } else if (isset($index['foreign_table'])) {
//                $index['name'] = " `foreign_$index[name]`";
//                $index['columns'] = [];
//                foreach ($index['import_join_columns'] as $import_join_column) {
//                    $index['columns'][$import_join_column['local']]['name'] = $import_join_column['local'];
//                    $index['columns'][$import_join_column['local']]['sequence'] = $import_join_column['sequence'];
//                }
//            } else continue;
//            uasort(
//                $index['columns'],
//                function ($a, $b) {
//                    return $a['sequence'] - $b['sequence'];
//                }
//            );
//            $columns_string = implode("`, `", array_pluck($index['columns'], 'name'));
//
//            $index_string .= "KEY$index[name] (`$columns_string`)";
//            $indices[] = $index_string;
//        }
//
//        return $indices;
//    }
}