<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/9/16
 * Time: 12:33 PM
 */

namespace Visionware\DataManager;

use Exception;

class DefinitionValidator {

    /**
     * Overrides the default Command handle method so that we can do the config/definition loading
     * @return mixed
     */
    static private $require_column_fields = [
        'name',
        'type',
        'null',
        'default',
        'extra',
    ];
    static private $require_index_fields = [
        'name',
        'unique',
        'columns',
    ];
    static private $require_table_fields = [
        'name',
        'columns',
        'indices',
    ];

    static public function validate($definition) {
        $errors = [];
        try {
            foreach ($definition['import_order'] as $import) {
                if (!isset($definition['tables'][$import])) $errors[] = "import_order.$import - Table is not defined";
                if (!isset($definition['tables'][$import]['import_file'])) {
                    $errors[] = "import_order.$import - Table has no import_file defined";
                }
            }
            foreach ($definition['tables'] as $tableKey => $table) {
                foreach (self::$require_table_fields as $require_table_field) {
                    if (!array_key_exists($require_table_field, $table)) {
                        $errors[] = "tables.$tableKey - Table has no $require_table_field defined";
                    }
                }
                if ($tableKey != $table['name']) {
                    $errors[] = "tables.$tableKey - Table name value does not match table key";
                }
                foreach ($table['columns'] as $columnKey => $column) {
                    foreach (self::$require_column_fields as $require_column_field) {
                        if (!array_key_exists($require_column_field, $column)) {
                            $errors[] = "tables.$tableKey.columns.$columnKey - Column has no $require_column_field defined";
                        }
                    }
                    if ($columnKey != $column['name']) {
                        $errors[] = "tables.$tableKey.columns.$columnKey - Column name value does not match column key";
                    }
                    if (isset($column['import_field']) && !isset($table['import_file'])) {
                        $errors[] = "tables.$tableKey.columns.$columnKey - No import_file defined for table";
                    }

                    if ((substr($column['name'], -2) == 'id') && $column['type'] != 'binary(16)') {
                        $errors[] = "tables.$tableKey.columns.$columnKey - ID column is not type binary(16)";
                    }
                }
                foreach ($table['indices'] as $indexKey => $index) {
                    foreach (self::$require_index_fields as $require_index_field) {
                        if (!array_key_exists($require_index_field, $index)) {
                            $errors[] = "tables.$tableKey.indices.$indexKey - Index has no $require_index_field defined";
                        }
                    }
                    if ($indexKey != $index['name']) {
                        $errors[] = "tables.$tableKey.indexs.$indexKey - Index name value does not match index key";
                    }
                    foreach ($index['columns'] as $columnKey => $column) {
                        if (!isset($column['name'])) {
                            $errors[] = "tables.$tableKey.indices.$indexKey.columns.$columnKey - Index column name is not defined";
                        }
                    }
                    if (isset($index['foreign_table']) && !isset($index['import_join_columns'])) {
                        $errors[] = "tables.$tableKey.indices.$indexKey.foreign_table - No import_join_columns definition for index";
                    }
                    if (isset($index['import_join_columns'])) {
                        if (!isset($index['foreign_table'])) {
                            $errors[] = "tables.$tableKey.indices.$indexKey.import_join_columns - No foreign_table definition for index";
                        }
                        foreach ($index['import_join_columns'] as $ijKey => $ij) {
                            if (!isset($table['columns'][$ij['local']])) {
                                $errors[] = "tables.$tableKey.indices.$indexKey.import_join_columns.$ijKey.local - Local column is not defined";
                            }
                            if (!isset($definition['tables'][$index['foreign_table']]['columns'][$ij['foreign']])) "tables.$tableKey.indices.$indexKey.import_join_columns.$ijKey.foreign - Foreign column is not defined";
                        }
                    }
                }
            }
        } catch (Exception $e) {
            $errors[] = "EXCEPTION CAUGHT: " . $e->getMessage();
        }
        if (count($errors) > 0) array_unshift($errors, 'DEFINITION VALIDATION FAILED!');

        return $errors;
    }
}