<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/27/16
 * Time: 7:59 AM
 */

namespace Visionware\DataManager\Schema;

use Illuminate\Database\Connection;

class MySqlSchemaInfo implements SchemaInfoInterface {
    protected $connection;
    protected $tables;

    public function __construct(Connection $connection) {
        $this->connection = $connection;
        foreach ($this->sql_table_names() as $table) {
            $this->tables[$table]['columns'] = $this->sql_columns($table);
            $this->tables[$table]['indices'] = $this->sql_indices($table);
        }
    }

    private function sql_table_names() {
        $keyName = "Tables_in_" . $this->connection->getDatabaseName();
        $results = $this->connection->select('SHOW FULL TABLES WHERE Table_type != "VIEW";');
        $tables = [];
        foreach ($results as $result) {
            if ($result->$keyName == 'datamanager_metadata') continue;
            $tables[] = $result->$keyName;
        }
        return $tables;
    }

    public function table_names() {
        return array_keys($this->tables !== null ? $this->tables : array());
    }

    public function column_names($table_name) {
        return array_keys($this->tables[$table_name]['columns'] !== null ? $this->tables[$table_name]['columns'] : array());
    }

    private function sql_columns($table_name) {
        $columns = $this->connection->select("SHOW COLUMNS FROM $table_name");
        $return = [];
        foreach ($columns as $column) {
//            print_r($column);
            $return[$column->Field] = [
                'name' => $column->Field,
                'type' => strtolower($column->Type),
                'nullable' => $column->Null == 'YES',
                'default' => strtoupper((is_null($column->Default) && $column->Null == 'YES') ? 'NULL' : $column->Default),
                'extra' => strtoupper($column->Extra),
            ];
        }
        return $return;
    }

    private function sql_indices($table_name) {
        $return = [];
        $indices = $this->connection->select("SHOW INDEXES FROM $table_name");
        foreach ($indices as $index_col) {
            if ($index_col->Key_name == 'PRIMARY') $type = 'PRIMARY KEY';
            else if ($index_col->Non_unique == '0') $type = 'UNIQUE KEY';
            else $type = 'KEY';

            $return[$index_col->Key_name]['type'] = $type;
            $return[$index_col->Key_name]['columns'][] = $index_col->Column_name;
            $return[$index_col->Key_name]['name'] = $index_col->Key_name;
        }
        foreach ($return as $name=>$item) {
            if (!strlen($item['name'])) $return[$name]['name'] = implode('-', $item['columns']);
        }
        if (array_key_exists('PRIMARY', $return)) {
            $keys = array_keys($return);
            $keys[array_search('PRIMARY', $keys)] = $return['PRIMARY']['name'];
            $return = array_combine($keys, $return);
        }
        return $return;
    }

    public function column($table_name, $column_name) {
        return $this->tables[$table_name]['columns'][$column_name];
    }

    public function index_names($table_name) {
        return array_keys($this->tables[$table_name]['indices']);
    }

    public function index($table_name, $index_name) {
        return $this->tables[$table_name]['indices'][$index_name];
    }
}