<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/13/16
 * Time: 11:09 AM
 */

namespace Visionware\DataManager;

use Monolog\Logger;
use Log;
use Visionware\DataManager\Schema\Schema;

abstract class DataManagerProcess {
    protected $table_name;
    protected $force;
    protected $logger;
    protected $schema;

    public function __construct(Schema $schema) {
        $this->schema = $schema;
        $this->force = false;
        $this->run_after_completed = false;
        $this->logger = Log::getMonolog();
    }

    abstract public function go();

    public function table_name($table_name) {
        $this->table_name = $table_name;
        return $this;
    }

    public function force($val = false) {
        $this->force = $val;
        return $this;
    }

    public function logger(Logger $logger) {
        $this->logger = $logger;
        return $this;
    }

    function __call($name, $arguments) {
        if (in_array($name, ['emergency', 'alert', 'critical', 'error', 'warn', 'notice', 'info', 'debug'])) {
            call_user_func_array([$this->logger, $name], $arguments);
            $arguments[1] = array_merge(isset($arguments[1]) ? $arguments[1] : [], ['datamanager-table' => $this->table_name]);
            $logger = Log::getMonolog();

            return call_user_func_array([$logger, $name], $arguments);
        } else if (starts_with($name, 'table_')) {
            $schema_method = preg_replace('/table_/', '', $name, 1);
            if (method_exists($this->schema, $schema_method)) {
                array_unshift($arguments, $this->table_name);
                return call_user_func_array([$this->schema, $schema_method], $arguments);
            }
        } else if (method_exists($this, $name)) {
            return call_user_func_array([$this, $name], $arguments);
        }
        trigger_error("Call to unhandled __call function $name()", E_USER_ERROR);
    }
}