<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DataManager;
use DB;
use Exception;
use Illuminate\Console\Command;
use Storage;
use Visionware\DataManager\Grammars\MysqlGrammar;
use Visionware\DataManager\Grammars\SqliteEmptyGrammar;
use Visionware\DataManager\Schema\MySqlSchemaInfo;
use Visionware\DataManager\Schema\SqliteSchema;
use Visionware\DataManager\SchemaManager;

class SchemaInfoCommand extends Command {
    protected $signature = 'datamanager:schema      
        {--mode= : Schema class to use }
        {--func= : schema function }
        {args?*}
    ';

    protected $description = 'Schema information';

    public function handle() {
        $schemaclassname = 'Visionware\\DataManager\\Schema\\' . ucfirst($this->option('mode')) . 'Schema';
        $schema = new $schemaclassname(DataManager::definition());
        $function = $this->option('func');
        $arguments = $this->argument('args');

        $response = call_user_func_array([$schema, $function], $arguments);
        $this->info(json_encode($response, JSON_PRETTY_PRINT));
    }
}