<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Logger;
use DataManager;
use Visionware\DataManager\Schema\ImporterSchema;
use Visionware\DataManager\Schema\Schema;

class IngestCommand extends Command {
    protected $signature = 'datamanager:ingest
        {--force : Process even if database is up-to-date}
        {--skip= : Comma separated list of tables to skip (overrides --only values)}
        {--only= : Comma separated list of tables to import (will skip everything else) }       
        {--queue : Push jobs to the application queue instead of processing now }
    ';
    protected $description = 'Ingests data';
    private $schema;

    private function process_skip_only($tables) {
        $skip = is_null($this->option('skip')) ? [] : explode(',', $this->option('skip'));
        $only = is_null($this->option('only')) ? [] : explode(',', $this->option('only'));
        $out = [];
        foreach ($tables as $table_name) {
            if (count($only) && !in_array($table_name, $only)) continue;
            if (in_array($table_name, $skip)) continue;
            $out[$table_name] = $table_name;
        }

        return array_values($out);
    }

    public function handle() {
        $this->schema = new ImporterSchema(DataManager::definition());

        foreach ($this->process_skip_only($this->schema->tables_to_ingest()) as $table_name) {
            $options = ['table' => $table_name];
            if ($this->option('force')) $options['--force'] = true;
            if ($this->option('queue')) Artisan::queue('datamanager:ingest-table', $options);
            else $this->call('datamanager:ingest-table', $options);
        }
    }
}