<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchema;
use Visionware\DataManager\Schema\Schema;

class ImportTableCommand extends Command {
    protected $signature = 'datamanager:import-table {table}
        {--force : Process even if database is up-to-date}
    ';

    protected $description = 'Imports a single table';

    public function handle() {
        $table_name = $this->argument('table');
        $logger = new Logger('import-' . $table_name);
        $handler = new RotatingFileHandler(
            storage_path('/logs/datamanager/import-' . $table_name . '.log'),
            7,
            Logger::INFO,
            true
        );
        $logger->pushHandler($handler);

        $console_handler = new ConsoleHandler(
            $this->getOutput(), true, [
                OutputInterface::VERBOSITY_NORMAL       => Logger::NOTICE,
                OutputInterface::VERBOSITY_VERBOSE      => Logger::INFO,
                OutputInterface::VERBOSITY_VERY_VERBOSE => Logger::DEBUG,
                OutputInterface::VERBOSITY_DEBUG        => Logger::DEBUG,
            ]
        );
        $logger->pushHandler($console_handler);

        $importer = DataManager::getImporter();
        $importer->table_name($table_name)->logger($logger);
        if ($this->option('force')) $importer->force(true);
        $importer->go();
    }
}