<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/18/16
 * Time: 12:25 PM
 */

namespace Visionware\DataManager\Schema;

class ImporterSchema extends Schema {

    public function tables_to_ingest() {
        $tables = [];
        foreach ($this->tables() as $table_name => $table) {
            if (!array_key_exists('imported_from', $table)) continue;

            $tables[$table_name] = $table;
        }
        return array_keys($tables);
    }

    public function tables_to_import() {
        /** @var Node[] $nodes */
        $nodes = [];
        $tables = [];
        foreach ($this->tables() as $table_name => $table) {
            $nodes[$table_name] = new Node($table_name);
            $should_import = false;
            if (array_key_exists('imported_from', $table)) $should_import = true;
            foreach ($table['fields'] as $field) if (array_key_exists('imported_from', $field)) $should_import = true;
            if (!$should_import) continue;

            $tables[$table_name] = $table;
        }

        $nodes['BASE'] = new Node('BASE');
        foreach ($tables as $table_name => $table) {
            foreach ($this->fields($table_name) as $field) {
                $fname = false;
                if (array_key_exists('on_table', $field)) $fname = $field['on_table'];
                else if (array_key_exists('imported_from', $field)) $fname = $field['imported_from'];
                if ($fname && $fname != $table_name) $nodes[$table_name]->dependsOn($nodes[$fname]);
            }
            $nodes['BASE']->dependsOn($nodes[$table_name]);
        }
        $order = [];
        $nodes['BASE']->resolve($order);
        foreach ($order as $k=>$v) if ($v == 'BASE') unset($order[$k]);
        return $order;
    }

    public function import_file($table_name) {
        return $this->table($table_name)['import_file'];
    }
}