<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 11:37 AM
 */

namespace Visionware\DataManager\Info;

use Elasticsearch\Endpoints\Index;
use Illuminate\Support\Collection;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

class ImportSchemaInfo extends HistorySchemaInfo {
    protected function initActions(ActionManager $actions) {
        $actions->table()->skipTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            return !$tableDefinition->isImported();
        });

        $actions->table()->replaceTable(function (TableDefinition $tableDefinition, TableInfo $tableInfo) {
            return $this->buildLatestTable($tableDefinition, $tableInfo);
        });

        return $actions;
    }
}