<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/13/16
 * Time: 11:09 AM
 */

namespace Visionware\DataManager;

use App;
use DataManager;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Logger;
use Log;
use Symfony\Bridge\Monolog\Formatter\ConsoleFormatter;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

abstract class DataManagerProcess implements HasCustomLogging {
    protected $tableName;
    /**
     * @var TableInfo
     */
    protected $info;
    /**
     * @var TableDefinition
     */
    protected $definition;
    protected $force;

    protected $schema;
    protected $logPrefix;

    public function getConsoleFormat() {
        return "%start_tag%[%datetime%] %channel%.{$this->processType}.%level_name%:%end_tag% %message% %context% %extra%\n";
    }


    public function __construct(SchemaInfo $schema) {
        $this->schema = $schema;
        $this->force = false;
        $this->logPrefix = '';
    }

    abstract public function go();

    public function setTable(string $tableName) {
        $this->info = $this->schema->tables()->get($tableName);
        $this->definition = $this->info->definition();
        $this->tableName = $tableName;
        return $this;
    }

    protected function setLogPrefix($prefix) {
        $this->logPrefix = $prefix;
    }

    public function prepareLogContext($context) {
        $context['datamanager-process'] = $this->processName;
        $context['datamanager-target'] = $this->logPrefix;
        return $context;
    }

    public function force($val = false) {
        $this->force = $val;
        return $this;
    }

    use HasCustomLoggingTrait;
}