<?php

return [
    'disk' => 'root',
    'path' => 'database/dmschema/',
    'import_source'         => [
        'disk'         => 'hilco-import-s3',
        'prepend_path' => env('DATAMANAGER_IMPORT_PATH_PREFIX', ''),
    ],
    'updater' => [
        'disk' => 'local',
        'path' => 'database/updater',
    ],
    'importer' => [
        'lock_path' => storage_path('importer.lock'),
    ],
    'history-database-connection' => 'hilco-history',
    'historyimport-database-connection' => 'hilco-historyimport',
    'live-database-connection' => 'hilco-live',
    'import-database-connection' => 'hilco-import',
    'history-database-schema' => '',
    'live-database-schema' => '',
    'import-database-schema' => '',
    'import-file-delim' => env('DATAMANAGER_IMPORT_FILE_DELIM',"\t"),
    'incoming-data-source' => env('DATAMANAGER_INCOMING_DATA_SOURCE',"s3"),
    'row_chunk_size' => 10000,
    'import-bucket' => env('AWS_S3_IMPORT_BUCKET'),
    'incoming-ftp' => [
        'host' => env('DATAMANAGER_INCOMING_FTP_HOST'),
        'port' => env('DATAMANAGER_INCOMING_FTP_PORT', 21),
        'user' => env('DATAMANAGER_INCOMING_FTP_USER'),
        'pass' => env('DATAMANAGER_INCOMING_FTP_PASS'),
        'pasv' => env('DATAMANAGER_INCOMING_FTP_PASV', true),
        'root' => env('DATAMANAGER_INCOMING_FTP_ROOT'),
    ]

];