<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 10:04 AM
 */

namespace Visionware\DataManager\Info;

use Illuminate\Support\Collection;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\IndexDefinition;
use Visionware\DataManager\Definition\TableDefinition;

class IndexInfo extends Info {
    private $table;
    private $name;
    private $type;
    private $columns;
    private $noCaseColumns = [];

    public function setTable(TableInfo $table) {
        $this->table = $table;
    }

    /**
     * @return TableInfo
     */
    public function table() {
        return $this->table;
    }

    public function setDefinition(IndexDefinition $definition) {
        $this->putOther('definition', $definition);
    }

    /**
     * @return IndexDefinition
     */
    public function definition() {
        return $this->getOther('definition');
    }

    public function setType($type) {
        $this->type = $type;
    }

    public function setColumns($columns) {
        ksort($columns);
        $this->columns = array_values($columns);
    }

    public function setNoCaseColumns($noCaseColumns) {
        if (isset($noCaseColumns)) {
            ksort($noCaseColumns);
            $this->noCaseColumns = array_values($noCaseColumns);
        } else {
            $this->noCaseColumns = [];
        }
    }

    public function setName($name) {
        if (!strlen($name)) $name = implode('_', $this->columns());
        $this->name = $name;
    }

    public function type() {
        return $this->type;
    }

    public function columns() {
        return $this->columns;
    }

    public function noCaseColumns() {
        return $this->noCaseColumns;
    }

    public function name() {
        return $this->isPrimaryKey() ? '' : $this->name;
    }

    public function isPrimaryKey() {
        return $this->type() == 'PRIMARY KEY';
    }

    public function clone() {
        return self::create($this->type(), $this->columns(), $this->name(), $this->noCaseColumns());
    }

    public function compareTo(IndexInfo $other) {
        $equal = ($this->name() == $other->name());
        $equal = $equal && ($this->columns() == $other->columns());
        return $equal;
    }
    
    public static function create($type, $columns, $name = '', $noCaseColumns = []) {
        $instance = new static();
        $instance->setType($type);
        $instance->setColumns($columns);
        $instance->setNoCaseColumns($noCaseColumns);
        $instance->setName($name);
        return $instance;
    }

    public static function createFromDefinition(IndexDefinition $index) {
        $instance = new static();

        $instance->setDefinition($index);
        $instance->setType($index->type());
        $instance->setName($index->name());
        $instance->setColumns($index->columns());
        $instance->setNoCaseColumns($index->noCaseColumns());

        return $instance;
    }

    public function __toString() {
        return "{$this->table()->name()} - {$this->name()} {$this->type()} (" . implode(', ', $this->columns()) . ") (" . implode(', ', $this->noCaseColumns()) . ")";
    }

    public function __toDebugArray() {
        return [
            'table' => $this->table()->name(),
            'name' => $this->name(),
            'type' => $this->type(),
            'columns' => $this->columns(),
            'noCaseColumns' => $this->noCaseColumns(),
        ];
    }

}