<?php

namespace Visionware\DataManager\Actions;

use Closure;
use Illuminate\Support\Collection;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;
use Visionware\DataManager\Info\ViewInfo;

/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/21/16
 * Time: 10:14 AM
 * @method prependTable(Closure $callback) Prepend a table to the schema. Callback arguments: SchemaDefinition, SchemaInfo. Callback should return TableInfo or a Collection of TableInfos
 * @method appendTable(Closure $callback) Append a table to the schema. Callback arguments: SchemaDefinition, SchemaInfo. Callback should return TableInfo or a Collection of TableInfos
 * @method appendView(Closure $callback) Append a view to the schema. Callback arguments: SchemaDefinition, SchemaInfo. Callback should return ViewInfo or a Collection of ViewInfos
 */
class SchemaAction extends Action {
    protected $allowedOperations = [
        'prependTable',
        'appendTable',
        'appendView',

    ];

    protected function executePrependTable(TableInfo $tableInfo, SchemaInfo $schemaInfo) {
        $tableInfo->setDerived();
        $schemaInfo->prependTable($tableInfo);
        return $schemaInfo;
    }

    protected function executeAppendTable(TableInfo $tableInfo, SchemaInfo $schemaInfo) {
        $tableInfo->setDerived();
        $schemaInfo->appendTable($tableInfo);
        return $schemaInfo;
    }
    
    protected function executeAppendView(ViewInfo $viewInfo, SchemaInfo $schemaInfo) {
        $schemaInfo->appendView($viewInfo);
        return $schemaInfo;
    }
}