<?php

return [
    'disk' => 'root',
    'path' => 'database/dmschema/',
    'import_source'         => [
        'disk'         => 'safilo-import-s3',
        'prepend_path' => env('DATAMANAGER_IMPORT_PATH_PREFIX', ''),
    ],
    'updater' => [
        'disk' => 'root',
        'path' => 'database/updater',
    ],
    'importer' => [
        'lock_path' => storage_path('importer.lock'),
    ],
    'history-database-connection' => 'safilo-history',
    'historyimport-database-connection' => 'safilo-historyimport',
    'live-database-connection' => 'safilo-live',
    'import-database-connection' => 'safilo-import',
    'history-database-schema' => env('DB_HISTORY_DATABASE'),
    'live-database-schema' => env('DB_LIVE_DATABASE'),
    'import-database-schema' => env('DB_IMPORT_DATABASE'),
    'row_chunk_size' => 10000,
    'import-bucket' => env('AWS_S3_IMPORT_BUCKET'),
    'file_delimiter' => env('FILE_DELIMITER'),
    'slack' => [
        'enabled' => env('SLACK_LOGGING', false),
        'level' => env('SLACK_LOGGING_LEVEL', \Monolog\Logger::NOTICE),
        'token' => env('SLACK_API_TOKEN'),
        'channel' => env('SLACK_CHANNEL'),
        'nick' => env('SLACK_NICK'),
    ],
];