<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchemaInfo;
use Visionware\DataManager\Schema\SchemaInfo;

class IngestTableCommand extends Command {
    protected $signature = 'datamanager:ingest-table {table}
        {--force : Process even if database is up-to-date}
        {--import-after : Used internally by queue workers }
        {--all-versions : Gets all past versions }
        {--skip-transactions : Don\'t do this }
        {--newer-than= : yyyy-mm-dd }
        {--latest-only : Only rebuilds latest records tables }
        {--log-name=ingest : Use an alternate log file name } 
        {--use-newest-only : Use only the newest version of the file } 
        {--all-records-latest : Don\'t check live db\'s modified time for append-only tables }
    ';

    protected $description = 'Ingests a single table';

    public function handle() {
        $table_name = $this->argument('table');
        $ingester = DataManager::getIngester($this->getOutput(), $this->option('log-name'));
        $ingester->setTable($table_name);
        if ($this->option('force')) $ingester->force(true);
        if ($this->option('all-versions')) $ingester->allVersions();
        if ($this->option('newer-than')) $ingester->newerThan($this->option('newer-than'));
        if ($this->option('skip-transactions')) $ingester->noTransactions();
        if ($this->option('latest-only')) $ingester->latestOnly();
        if ($this->option('use-newest-only')) $ingester->newestFileOnly();
        if ($this->option('all-records-latest')) $ingester->allRecordsInLatest();
        $ingester->go();
    }
}