<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Illuminate\Console\Command;
use Visionware\DataManager\Facades\DataManager;

class ImportCommand extends Command {
    protected $signature = 'datamanager:import 
        {--force : Process even if database is up-to-date}
        {--skip-transactions : Don\' do this}
        {--no-post : No post-import sql}
        {--only-post : Only post-import sql}
        {--single-table= : Or this}
    ';

    protected $description = 'Imports all tables';

    public function handle() {
        $importer = DataManager::getImporter();
        $importer->logger(DataManager::getLogger('importer', $this->getOutput()));
        if ($this->option('force')) $importer->force(true);
        if ($this->option('no-post')) $importer->skipPostSql();
        if ($this->option('only-post')) $importer->onlyPostSql();
        if ($this->option('skip-transactions')) $importer->noTransactions();
        if ($this->option('single-table')) {
            $importer->noTransactions();
            $importer->only($this->option('single-table'));
        }
        $importer->go();
    }
}