<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 4:47 PM
 */

namespace Visionware\DataManager;
class HistorySchemaCreator extends SchemaCreator {
    protected $statements = [
        'schema' => [
//            'drop_schema' => 'DROP DATABASE hilco_dev_history_2;',
            'create_schema' => 'create_schema',
            'use_schema'    => 'use_schema',
        ],
        'table'  => [
            'records_table' => 'create_table',
            'files_table'   => 'create_table',
            'staging_table' => 'create_table',
            'latest_view' => 'CREATE VIEW `%table%_latest` AS SELECT r.*, `f`.`last_modified` AS `import_file_last_modified` FROM %table%_records r JOIN %table%_files f ON (f.record_id = r.id) WHERE f.last_modified IN ( SELECT max(last_modified) FROM %table%_files);',
            'files_view' => 'CREATE VIEW `%table%_files_list` AS SELECT distinct last_modified FROM %table%_files f ORDER BY last_modified DESC;',
        ],
    ];

    private $helpers = [
        'id_column'            => [
            'name'        => 'id',
            'type'        => 'INT(11)',
            'null'        => false,
            'default'     => null,
            'extra' => 'AUTO_INCREMENT',
            'column_type' => 'primary',
        ],
        'record_hash_column'   => [
            'name'        => 'record_hash',
            'type'        => 'VARCHAR(32)',
            'null'        => false,
            'default'     => null,
            'column_type' => 'column',
        ],
        'last_modified_column' => [
            'name'        => 'last_modified',
            'type'        => 'DATETIME',
            'null'        => false,
            'default'     => null,
            'column_type' => 'column',
        ],
        'record_id_column'     => [
            'name'        => 'record_id',
            'type'        => 'INT(11)',
            'null'        => false,
            'default'     => null,
            'column_type' => 'column',
        ],
        'sequence_column'      => [
            'name'        => 'sequence',
            'type'        => 'INT(11)',
            'null'        => false,
            'default'     => null,
            'column_type' => 'column',
        ],
        'id_index'             => [
            'name'       => 'PRIMARY',
            'unique'     => true,
            'columns'    => ['id' => ['name' => 'id', 'sequence' => 1]],
            'index_type' => 'primary',
        ],
        'file_record_index'    => [
            'name'       => 'file_record',
            'unique'     => true,
            'columns'    => [
                'last_modified' => ['name' => 'last_modified', 'sequence' => 1],
                'sequence'      => ['name' => 'sequence', 'sequence' => 2],
            ],
            'index_type' => 'index',
        ],
        'record_index'         => [
            'name'       => 'record',
            'unique'     => false,
            'columns'    => ['record_id' => ['name' => 'record_id', 'sequence' => 1]],
            'index_type' => 'index',
        ],
        'time_index'           => [
            'name'       => 'time',
            'unique'     => false,
            'columns'    => ['last_modified' => ['name' => 'last_modified', 'sequence' => 1]],
            'index_type' => 'index',
        ],
        'record_hash_index'         => [
            'name'       => 'record_hash',
            'unique'     => true,
            'columns'    => ['record_hash' => ['name' => 'record_hash', 'sequence' => 1]],
            'index_type' => 'index',
        ],
    ];

    protected function filter_table($table) {
        if ($table['table_type'] !== 'imported') return false;

        return $table;
    }

    protected function filter_column($column, $table) {
        if (!in_array($column['column_type'], ['column', 'foreign_key'])) return false;
        if (strcasecmp(substr($column['type'], 0, 7), 'varchar')) $column['type'] = 'varchar(32)';

        return $column;
    }

    protected function filter_index($index, $table) {
        $return = false;
        if ($index['index_type'] == 'unique_key') {
            $index['unique'] = false;
            $return = $index;
        } else {
            if ($index['index_type'] == 'primary') {
                $return = $index;
            }
        }

        return $return;
    }

    protected function filter_records_table($table) {
        $table['name'] = $table['name'] . '_records';

        $new_columns = [
            'id'          => $this->helpers['id_column'],
            'record_hash' => $this->helpers['record_hash_column'],
        ];
        $old_columns = $table['columns'];
        $table['columns'] = array_merge($new_columns, $old_columns);

        $table['indices'] = [
            'PRIMARY' => $table['indices']['PRIMARY'],
            'record_hash'      => $this->helpers['record_hash_index'],
            'unique_key' => $table['indices']['unique_key'],
        ];
        $table['indices']['unique_key']['unique'] = false;

        return $table;
    }

    protected function filter_files_table($table) {
        $table['name'] = $table['name'] . '_files';

        $table['columns'] = [
            'id'            => $this->helpers['id_column'],
            'last_modified' => $this->helpers['last_modified_column'],
            'record_id'     => $this->helpers['record_id_column'],
            'sequence'      => $this->helpers['sequence_column'],
        ];

        $table['indices'] = [
            'PRIMARY'          => $this->helpers['id_index'],
            'file_record' => $this->helpers['file_record_index'],
            'record'      => $this->helpers['record_index'],
            'time'        => $this->helpers['time_index'],
        ];

        return $table;
    }

    protected function filter_staging_table($table) {
        $table['name'] = $table['name'] . '_staging';

        $new_columns = [
            'id'            => $this->helpers['id_column'],
            'last_modified' => $this->helpers['last_modified_column'],
            'sequence'      => $this->helpers['sequence_column'],
            'record_hash'      => $this->helpers['record_hash_column'],
        ];
        $old_columns = $table['columns'];
        $table['columns'] = array_merge($new_columns, $old_columns);


        $new_indices = [
            'PRIMARY' => $table['indices']['PRIMARY'],
            'record_hash'      => $this->helpers['record_hash_index'],
        ];
        $table['indices'] = $new_indices;

        return $table;
    }
}