<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/17/16
 * Time: 12:47 PM
 */

namespace Visionware\DataManager\Schema;

class Node {
    public $name;
    private $dependencies;

    /**
     * Node constructor.
     * @param $name
     */
    public function __construct($name) {
        $this->name = $name;
        $this->dependencies = [];
    }
    public function dependsOn(Node $node) {
        $this->dependencies[$node->name] = $node;
    }

    public function resolve(&$resolved) {
        foreach ($this->dependencies as $name => $dependency) {
            if (!in_array($dependency->name, $resolved)) {
                $dependency->resolve($resolved);
            }
        }
        $resolved[] = $this->name;
    }

    public function walk($tab = '') {
        print $tab . $this->name . "\n";
        foreach ($this->dependencies as $name => $dependency) {
            $dependency->walk($tab . "  ");
        }
    }
}