<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 8/5/16
 * Time: 9:29 AM
 */

namespace Visionware\DataManager;

use Illuminate\Database\Connection;
use Monolog\Logger;
use Carbon\Carbon;

abstract class BaseUpdater {

    /**
     * @var Connection
     */
    protected $db;

    /**
     * @var Logger
     */
    protected $logger;

    protected $sequences = [];
    private $sequenceNumbers;

    public function __construct($db, $logger) {
        $this->db = $db;
        $this->logger = $logger;
    }

    public function go() {
        sort($this->sequences);
        $this->sequenceNumbers = [];
        foreach ($this->sequences as $table) {
            $this->logger->info("Attempting to lock and read max commit sequence for $table...");
            $this->sequenceNumbers[$table] = $this->db->table($table)->lockForUpdate()->max('commit_sequence') + 1;
        }
        $this->execute();
    }

    abstract protected function execute();

    protected function queryWithSequence($table, $sql, $bindings = []) {
        $bindings['commit_sequence'] = $this->sequenceNumbers[$table];
        $this->query($sql, $bindings);
    }

    protected function query($sqls, $bindings = []) {
        if (!is_array($sqls)) $sqls = [$sqls];
        foreach ($sqls as $desc => $sql) {
            $this->logger->info("[$desc] Executing statement...");
            $this->logger->debug($sql, $bindings);
            $qStart = Carbon::now();
            $count = $this->db->affectingStatement($sql, $bindings);
            $qDiff = Carbon::now()->diffForHumans($qStart, true);
            $this->logger->notice("[$desc] Affected $count rows in $qDiff total");
        }
    }
}