<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DB;
use Exception;
use Storage;
use Visionware\DataManager\Grammars\MysqlGrammar;
use Visionware\DataManager\Schema\LiveSchema;
use Visionware\DataManager\SchemaManager;

class CreateModelPHPDoc extends DataManagerCommand {
    protected $datamanager_command_name = 'datamanager:model';
    protected $datamanager_signature = '
            {--output= : Output to a file instead of stdout.}
            {--table= }
    ';

    protected $description = 'Creates phpdoc for a model';

    protected function datamanager_handle() {
        $schema = new LiveSchema($this->definition);
        $table_name = $this->option('table');

        $properties = '';
        foreach ($schema->columns($table_name) as $column) {
            $type = 'mixed';
            if (starts_with($column['type'], 'varchar')) $type = 'string';
            else if (starts_with($column['type'], 'int')) $type = 'integer';
            $properties .= <<<PEND
 * @property $type $column[name]\n
PEND;
        }


        if ($schema->has_uuid($table_name)) $properties .= " * @property-read mixed \$id_string\n";

        $output = <<<OEND
/**
 * namespace Hilco\Models;
 *
$properties
 */
OEND;
        if ($this->option('output')) {
            file_put_contents($this->option('output'), $output);
            $this->info('Statements written to file: ' . $this->option('output'));
        } else {
            print $output;
        }
    }
}