<?php

namespace Visionware\DataManager;

use Illuminate\Support\Collection;
use Monolog\Logger;
use Visionware\DataManager\Grammars\Grammar;
use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\Info;
use Visionware\DataManager\Info\TableInfo;
use Visionware\DataManager\Info\ViewInfo;

/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/21/16
 * Time: 3:38 PM
 */
class DeltaManager {
    private $deltas;

    public function __construct() {
        $this->deltas = new Collection;
    }

    private function pushDelta($type, Info $target) {
        $list = $this->deltas->get($type, false);
        if (false === $list) {
            $list = new Collection;
            $this->deltas->put($type, $list);
        }
        $list->push($target);
    }

    public function createTable(TableInfo $table) {
        $this->pushDelta('createTable', $table);
    }

    public function dropTable(TableInfo $table) {
        $this->pushDelta('dropTable', $table);
    }
    
    public function createColumn(ColumnInfo $column) {
        $this->pushDelta('createColumn', $column);
    }

    public function dropColumn(ColumnInfo $column) {
        $this->pushDelta('dropColumn', $column);
    }

    public function createIndex(IndexInfo $index) {
        $this->pushDelta('createIndex', $index);
    }

    public function dropIndex(IndexInfo $index) {
        $this->pushDelta('dropIndex', $index);
    }

    public function alterIndex(IndexInfo $index) {
        $this->pushDelta('dropIndex', $index);
        $this->pushDelta('createIndex', $index);
    }

    public function alterColumn(ColumnInfo $column) {
        $this->pushDelta('alterColumn', $column);
    }

    public function createView(ViewInfo $view) {
        $this->pushDelta('createView', $view);
    }

    public function dropView(ViewInfo $view) {
        $this->pushDelta('dropView', $view);
    }

    public function alterView(ViewInfo $view) {
        $this->pushDelta('dropView', $view);
        $this->pushDelta('createView', $view);
    }
    
    public function compile(Grammar $grammar, HasCustomLogging $logger = null) {
        $statements = new Collection;
        $order = ['dropIndex', 'dropColumn', 'alterColumn', 'dropTable', 'createTable', 'createColumn', 'createIndex', 'dropView', 'createView'];
        foreach ($order as $type) {
            $deltas = $this->deltas->get($type, []);
            foreach ($deltas as $target) {
                if ($logger) {
                    $logger->notice(str_pad("$type: ", 15, ' ') . $target);
                    $logger->debug("$type", [$target->__toDebugArray()]);
                }
                $statements->push($grammar->$type($target));
            }
        }
        return $statements;
    }
}