<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 10:04 AM
 */

namespace Visionware\DataManager\Info;

use Illuminate\Support\Collection;
use Symfony\Component\Console\Helper\Table;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\FieldDefinition;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;

class ColumnInfo extends Info {
    private $table;
    private $name;
    private $type;
    private $nullable;
    private $default;
    private $extra;

    public function setName($name) {
        $this->name = $name;
    }

    public function setType($type) {
        $this->type = $type;
    }

    public function setNullable($nullable) {
        $this->nullable = $nullable;
    }

    public function setDefault($default) {
//        if (!$this->nullable && $default == 'NULL') $default = '';
        $this->default = $default;
    }

    public function setExtra($extra) {
        $this->extra = $extra;
    }

    public function setTable($tableInfo) {
        $this->table = $tableInfo;
    }

    public function setDefinition(FieldDefinition $field) {
        $this->putOther('definition', $field);
    }

    /**
     * @return FieldDefinition
     */
    public function definition() {
        return $this->getOther('definition');
    }

    public static function createFromDefinition(FieldDefinition $field) {
        $instance = new static();
        $instance->setDefinition($field);
        $name = $field->name();
        $instance->setName($field->name());
        $instance->setType($field->type());
//        if ($field->onTable() && $field->onTable() != $table->name()) {
//            $foreignTableDefinition = $schema->tables()->get($field->onTable());
//            $foreignTableInfo = TableInfo::createFromDefinition($schema, $foreignTableDefinition, $info);
//            $foreignColumn = $foreignTableInfo->columns()->get($field->foreign());
//            $type = $foreignColumn->type();
//        }
        $instance->setNullable($field->isNullable());
        $instance->setDefault($field->default());
        $instance->setExtra($field->extra());

        return $instance;
    }

    public static function create($name, $type, $nullable = false, $default = '', $extra = '') {
        $instance = new static;
        $instance->setName($name);
        $instance->setType($type);
        $instance->setNullable($nullable);
        $instance->setDefault($default);
        $instance->setExtra($extra);
        return $instance;
    }

    /**
     * @return ColumnInfo
     */
    public function clone() {
        return self::create($this->name(), $this->type, $this->nullable(), $this->default(), $this->extra());
    }

    public function name() {
        return $this->name;
    }

    public function type() {
        return strtolower($this->type);
    }

    public function setDerived() {
        $this->putOther('derived', true);
    }

    public function isDerived() {
        return $this->getOther('derived', false);
    }

    public function qualifiedType() {
        if ($this->definition() && $this->definition()->onTable()) {
            $foreignTable = $this->table()->schema()->tables()->get($this->definition()->onTable());
            if (is_null($foreignTable)) {
                var_dump($this);
            }
            $foreignColumn = $foreignTable->columns()->get($this->definition()->foreign());
            if (!is_null($foreignColumn)) return $foreignColumn->type();
        }
        return $this->type();
    }
    
    public function nullable() {
        return $this->nullable;
    }

    public function default() {
        if ($this->nullable) {
            if (strlen($this->default) < 1) return "NULL";
        } else {
            if ($this->default === 'NULL') return '';
        }
        return $this->default;
    }

    public function extra() {
        return strtoupper($this->extra);
    }

    /**
     * @return TableInfo
     */
    public function table() {
        return $this->table;
    }

    public function compareTo(ColumnInfo $other) {
        $equal = $this->name() == $other->name();
        $equal = $equal && str_replace(', ', ',', $this->qualifiedType()) == str_replace(', ', ',', $other->qualifiedType());
        $equal = $equal && $this->nullable() == $other->nullable();
        $equal = $equal && strtolower(preg_replace('/^[\'"]|[\'"]$/', '', $this->default())) == strtolower(preg_replace('/^[\'"]|[\'"]$/', '', $other->default()));
        $equal = $equal && $this->extra() == $other->extra();
        if (!$equal) {
            print $this->qualifiedType() . ' -> ' . $other->qualifiedType() . "\n";
        }
        return $equal;
    }

    public function __toString() {
        return "{$this->table()->name()} - {$this->name()} {$this->type()}";
    }

    public function __toDebugArray() {
        return [
            'name' => $this->name(),
            'type' => $this->type(),
        ];
    }
}