<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchemaInfo;
use Visionware\DataManager\Schema\SchemaInfo;

class TransfererCommand extends Command {
    protected $signature = 'datamanager:transfer        
        {--only= : Only this table }
        {--log-name=transfer : Use an alternate log file name } 

    ';

    protected $description = 'Transfers a table from history to import';

    public function handle() {
        $transferer = DataManager::getTransferer($this->getOutput(), $this->option('log-name'));
        if ($this->option('only')) $transferer->only($this->option('only'));
        $transferer->go();
    }
}