<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/27/16
 * Time: 4:47 PM
 */

namespace Visionware\DataManager;
class HistorySchemaCreator extends SchemaCreator {
    protected $statements = [
        'schema' => [
            'create_schema' => ['create' => 'create_schema', 'drop' => 'drop_schema'],
            'use_schema'    => 'use_schema',
        ],
        'table'  => [
            'records_table'     => ['create' => 'create_table', 'drop' => 'drop_table'],
            'files_table'       => ['create' => 'create_table', 'drop' => 'drop_table'],
            'snapshots_table'   => ['create' => 'create_table', 'drop' => 'drop_table'],
            'file_record_table' => ['create' => 'create_table', 'drop' => 'drop_table'],
            'staging_table'     => ['create' => 'create_table', 'drop' => 'drop_table'],
            'latest_view'       => [
                'create' => 'CREATE VIEW `%table%_latest` AS SELECT r.*, `f`.`last_modified` AS `import_file_last_modified` FROM %table%_records r JOIN %table%_file_record j ON (j.record_hash = r.record_hash) JOIN %table%_files f ON (j.file_id = f.id) JOIN %table%_snapshots sn ON (f.id = sn.file_id) WHERE sn.last_modified IN ( SELECT max(last_modified) FROM %table%_snapshots);',
                'drop'   => 'DROP VIEW IF EXISTS `%table%_latest`;',
            ],
        ],
    ];

    protected function filter_table($table) {
        if ($table['table_type'] == 'imported' || $table['table_type'] == 'derived') return $table;

        return false;
    }

    protected function filter_column($column, $table) {
        if ($column['name'] == 'id') return false;
        if (!in_array($column['column_type'], ['column', 'foreign_key'])) return false;
        if (strcasecmp(substr($column['type'], 0, 7), 'varchar')) $column['type'] = 'varchar(32)';

        return $column;
    }

    protected function filter_index($index, $table) {
        $return = false;
        if ($index['index_type'] == 'unique_key') {
            $index['unique'] = false;
            $return = $index;
        } else {
            if ($index['index_type'] == 'primary') {
                $return = $index;
            }
        }

        return $return;
    }

    protected function filter_records_table($table) {
        $table['name'] = $table['name'] . '_records';

        $new_columns = [
            'record_hash' => [
                'name'        => 'record_hash',
                'type'        => 'VARCHAR(32)',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
        ];
        $table['columns'] = array_merge($new_columns, $table['columns']);

        $table['indices'] = [
            'PRIMARY'    => [
                'name'       => 'PRIMARY',
                'unique'     => true,
                'columns'    => ['record_hash' => ['name' => 'record_hash', 'sequence' => 1]],
                'index_type' => 'primary',
            ],
            'unique_key' => $table['indices']['unique_key'],
        ];
        $table['indices']['unique_key']['unique'] = false;

        return $table;
    }

    protected function filter_file_record_table($table) {
        $table['name'] = $table['name'] . '_file_record';

        $table['columns'] = [
            'file_id'     => [
                'name'        => 'file_id',
                'type'        => 'INT(11) UNSIGNED',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'record_hash' => [
                'name'        => 'record_hash',
                'type'        => 'VARCHAR(32)',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'sequence'    => [
                'name'        => 'sequence',
                'type'        => 'INT(11) UNSIGNED',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
        ];

        $table['indices'] = [
            'PRIMARY' => [
                'name'       => 'PRIMARY',
                'unique'     => true,
                'columns'    => [
                    'file_id'     => ['name' => 'file_id', 'sequence' => 1],
                    'record_hash' => ['name' => 'record_hash', 'sequence' => 2],
                    'sequence'    => ['name' => 'sequence', 'sequence' => 3],
                ],
                'index_type' => 'index',
            ],
        ];

        return $table;
    }

    protected function filter_files_table($table) {
        $table['name'] = $table['name'] . '_files';

        $table['columns'] = [
            'id'            => [
                'name'        => 'id',
                'type'        => 'INT(11) UNSIGNED',
                'null'        => false,
                'default'     => null,
                'extra'       => 'AUTO_INCREMENT',
                'column_type' => 'primary',
            ],
            'file_name'     => [
                'name'        => 'file_name',
                'type'        => 'VARCHAR(128)',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'last_modified' => [
                'name'        => 'last_modified',
                'type'        => 'DATETIME',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
        ];

        $table['indices'] = [
            'PRIMARY'    => [
                'name'       => 'PRIMARY',
                'unique'     => true,
                'columns'    => [
                    'id' => ['name' => 'id', 'sequence' => 1],
                ],
                'index_type' => 'primary',
            ],
            'unique_key' => [
                'name'       => 'unique_key',
                'unique'     => true,
                'columns'    => [
                    'file_name'     => ['name' => 'file_name', 'sequence' => 1],
                    'last_modified' => ['name' => 'last_modified', 'sequence' => 2],
                ],
                'index_type' => 'unique',
            ],
        ];

        return $table;
    }

    protected function filter_snapshots_table($table) {
        $table['name'] = $table['name'] . '_snapshots';

        $table['columns'] = [
            'last_modified' => [
                'name'        => 'last_modified',
                'type'        => 'DATETIME',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'file_id'       => [
                'name'        => 'file_id',
                'type'        => 'INT(11) UNSIGNED',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
        ];

        $table['indices'] = [
            'unique_key' => [
                'name'       => 'unique_key',
                'unique'     => true,
                'columns'    => [
                    'last_modified' => ['name' => 'last_modified', 'sequence' => 1],
                    'file_id'       => ['name' => 'file_id', 'sequence' => 2],
                ],
                'index_type' => 'unique',
            ],
        ];

        return $table;
    }

    protected function filter_staging_table($table) {
        $table['name'] = $table['name'] . '_staging';

        $new_columns = [
            'last_modified' => [
                'name'        => 'last_modified',
                'type'        => 'DATETIME',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'record_hash'   => [
                'name'        => 'record_hash',
                'type'        => 'VARCHAR(32)',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'sequence'      => [
                'name'        => 'sequence',
                'type'        => 'INT(11) UNSIGNED',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
            'file_name'     => [
                'name'        => 'file_name',
                'type'        => 'VARCHAR(128)',
                'null'        => false,
                'default'     => null,
                'column_type' => 'column',
            ],
        ];
        $table['columns'] = array_merge($new_columns, $table['columns']);

        $table['indices'] = [
            'PRIMARY' => [
                'name'       => 'PRIMARY',
                'unique'     => true,
                'columns'    => ['record_hash' => ['name' => 'record_hash', 'sequence' => 1]],
                'index_type' => 'primary',
            ],
        ];

        return $table;
    }
}