<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DB;
use Illuminate\Console\Command;
use InvalidArgumentException;
use Storage;
use Visionware\DataManager\DefinitionValidator;

class YamlConverter extends Command {
    protected $signature = 'datamanager:yaml {--yaml} {--json} {--x} {input? : Read from a file instead of STDIN}';

    protected $description = 'Converts between YAML and JSON';

    public function handle() {
        $ff = $this->argument('input') ? fopen($this->argument('input'), 'r') : STDIN;
        $data = '';
        while (($row = fgets($ff)) !== false) {
            $data .= $row;
        }
        fclose($ff);
        if ($this->option('x')) {
//            $data = $this->extract_import_defs($data);
            $data = $this->convert_internal($data);
        }
        if ($this->option('json')) {
            print json_encode(yaml_parse($data), JSON_PRETTY_PRINT);
        } else {
            $json = json_decode($data, true);
            print yaml_emit($json, true);
        }
    }

    public function converxt_summary($data) {
        $imports = yaml_parse_file('database/dmschema/import_map.yml');
        $map = [];
        foreach ($imports as $key=>$info) {
            $map[$info['import_file']] = $key;
        }
        $json = json_decode($data, true);
        $yaml = [];
        foreach ($json['tables'] as $tblkey => $tbl) {
            if ($tbl['table_type'] != 'summary') continue;
            $fields = [];
            foreach ($tbl['columns'] as $key=>$column) {
                if (in_array($key, ['id', 'date_created', 'date_modified', 'deleted_at'])) continue;
                $fields[$key]['type'] = $column['type'];
                $fields[$key]['nullable'] = !(array_key_exists('null', $column) && $column['null'] === false);
                if (array_key_exists('default', $column)) {
                    $fields[$key]['default'] = ((is_null($column['default']) || strtolower($column['default']) == 'null')) ? 'null' : $default = $column['default'];
                }
                switch ($column['column_type']) {
                    case 'column':
                    case 'foreign_key':
                        if (array_key_exists('import_field', $column)) {
                            $fields[$key]['imported_from'] = $map[$tbl['import_file']];
                            if (array_key_exists('import_transformation', $column)) $fields[$key]['transformation'] = $column['import_transformation'];
                        }
                        break;
                    case 'foreign_id':
                        $fields[$key]['foreign'] = $column['references_column'];
                        $fields[$key]['on_table'] = $column['references_on'];
                        break;
                }

            }
            $yaml[$tblkey] = [
                'has_uuid' => true,
                'fields' => $fields,
            ];
        }
        print join("\n", array_slice(explode("\n", yaml_emit($yaml, true)), 0, -2));
        die;
    }

    public function convert_internal($data) {
//        $imports = yaml_parse_file('database/dmschema/files.yml');
//        $map = [];
//        foreach ($imports as $key=>$info) {
//            $map[$info['import_file']] = $key;
//        }
        $json = json_decode($data, true);
        $yaml = [];
        foreach ($json['tables'] as $tblkey => $tbl) {
            if ($tbl['table_type'] != 'internal' && $tbl['table_type'] != 'jobson') continue;
            $fields = [];
            foreach ($tbl['columns'] as $key=>$column) {
                $field = [];
                if (in_array($key, ['id', 'date_created', 'date_modified', 'deleted_at'])) continue;
                $field['name'] = $key;
                $field['type'] = $column['type'];
                $nullable = (!(array_key_exists('null', $column) && $column['null'] === false));
                $default_null = array_key_exists('default', $column) && (is_null($column['default']) || strtolower($column['default']) == 'null');
                $default_other = array_key_exists('default', $column) && strlen($column['default']);
                if ($nullable) $field['nullable'] = true;
                if ($default_null && $nullable) $field['default'] = 'null';
                if ($default_other) $field['default'] = $column['default'];
                switch ($column['column_type']) {
                    case 'column':
                        break;
                    case 'foreign_id':
//                        print_r($tbl);
                        $field['foreign'] = $column['references_column'];
                        $field['on_table'] = $column['references_on'];
                        break;
                }
                $fields[] = $field;
            }
            $item = [
                'table' => $tblkey,
                'has_uuid' => true,
                'fields' => $fields,
            ];
            $key = [];
            if (array_key_exists('unique_key', $tbl['indices'])) {
                $keycols = [];
                foreach ($tbl['indices']['unique_key']['columns'] as $keycol=>$info) $keycols[$info['sequence']] = $keycol;
                ksort($keycols, SORT_NUMERIC);
                $key = array_values($keycols);
                $item['key'] = $key;
            }

            $yaml[] = $item;
        }
        print join("\n", array_slice(explode("\n", yaml_emit($yaml, true)), 0, -2));
        die;
    }

    public function convert_imported($data) {
//        $imports = yaml_parse_file('database/dmschema/files.yml');
//        $map = [];
//        foreach ($imports as $key=>$info) {
//            $map[$info['import_file']] = $key;
//        }
        $json = json_decode($data, true);
        $yaml = [];
        foreach ($json['tables'] as $tblkey => $tbl) {
            if ($tbl['table_type'] != 'imported' && $tbl['table_type'] != 'derived') continue;
            $fields = [];
            foreach ($tbl['columns'] as $key=>$column) {
                $field = [];
                if (in_array($key, ['id', 'date_created', 'date_modified', 'deleted_at'])) continue;
                $field['name'] = $key;
                $field['type'] = $column['type'];
                $nullable = (!(array_key_exists('null', $column) && $column['null'] === false));
                $default_null = array_key_exists('default', $column) && (is_null($column['default']) || strtolower($column['default']) == 'null');
                $default_other = array_key_exists('default', $column) && strlen($column['default']);
                if ($nullable) $field['nullable'] = true;
                if ($default_null && $nullable) $field['default'] = 'null';
                if ($default_other) $field['default'] = $column['default'];
                switch ($column['column_type']) {
                    case 'column':
                    case 'foreign_key':
                        if (array_key_exists('import_field', $column)) {
                            $field['import_field'] = $column['import_field'];
                            if (array_key_exists('import_transformation', $column)) $field['transformation'] = $column['import_transformation'];
                        }
                        break;
                    case 'foreign_id':
                        $idinfo = $tbl['indices'][$key];
                        $using = [];
                        foreach ($idinfo['import_join_columns'] as $colinfo) {
                            $using[$colinfo['sequence']] = [
                                'local' => $colinfo['local'],
                                'foreign' => $colinfo['foreign']
                            ];
                        }
                        ksort($using, SORT_NUMERIC);
                        $field['foreign'] = $column['references_column'];
                        $field['on_table'] = $column['references_on'];
                        foreach ($using as $info) $field['join_on'][] = $info;
                        break;
                }
                $fields[] = $field;
            }
            $key = [];
            if (array_key_exists('unique_key', $tbl['indices'])) {
                $keycols = [];
                foreach ($tbl['indices']['unique_key']['columns'] as $keycol=>$info) $keycols[$info['sequence']] = $keycol;
                ksort($keycols, SORT_NUMERIC);
                $key = array_values($keycols);
            }
            $yaml[] = [
                'table' => $tblkey,
                'has_uuid' => true,
                'imported_from' => $tbl['import_file'],
                'fields' => $fields,
                'key' => $key,
            ];
        }
        print join("\n", array_slice(explode("\n", yaml_emit($yaml, true)), 0, -2));
        die;
    }

    public function extract_import_defs($data) {
        $json = json_decode($data, true);
        $yaml = [];
        foreach ($json['tables'] as $tblkey => $tbl) {
            if (!array_key_exists('import_file', $tbl)) continue;
            $item = ['file' => $tbl['import_file']];
            foreach ($tbl['columns'] as $key=>$column) {
                if (!array_key_exists('import_field', $column)) continue;
                $field = ['name' => $key, 'source' => $column['import_field']];
//                $field = ['description' => ''];
//                if (array_key_exists('import_transformation', $column)) $field['transform'] = $column['import_transformation'];
                $item['fields'][] = $field;
            }
            $keycols = [];
            foreach ($tbl['indices']['unique_key']['columns'] as $keycol=>$info) $keycols[$info['sequence']] = $keycol;
            ksort($keycols, SORT_NUMERIC);
            $item['key'] = array_values($keycols);
            $yaml[] = $item;
        }
        print join("\n", array_slice(explode("\n", yaml_emit($yaml, true)), 0, -2));
        die;
    }
}
