<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DB;
use Exception;
use Storage;
use Visionware\DataManager\ErpfeedSchemaManager;
use Visionware\DataManager\Grammars\MysqlGrammar;
use Visionware\DataManager\HistorySchemaManager;
use Visionware\DataManager\LiveSchemaManager;
use Visionware\DataManager\SchemaManager;
use Visionware\DataManager\SqliteSchemaCreator;
use Visionware\DataManager\ErpfeedSchemaCreator;
use Visionware\DataManager\LiveSchemaCreator;

class CreateSchema extends DataManagerCommand {
    protected $datamanager_command_name = 'datamanager:create';
    protected $datamanager_signature = '
            {--output= : Output to a file instead of stdout.}
            {--mode= : Creation mode history, live, sqlite, erpfeed, all (history, live, erpfeed) }
            {--drop : Includes drop statements}
    ';

    protected $description = 'Builds create statements';

    protected function datamanager_handle() {
        if ($this->option('mode') == 'sqlite' && is_null($this->option('output'))) {
            $this->error("You must specify an output file when using SQLite mode!");
            return false;
        }

        $modes = $this->option('mode') == 'all' ? ['history', 'live', 'erpfeed'] : [$this->option('mode')];

//        $history_db_name = Config::get('database.connections.' . $this->config['history-database-connection'] . '.database');
//        $live_db_name = Config::get('database.connections.' . $this->config['live-database-connection'] . '.database');
//        $erpfeed_db_name = Config::get('database.connections.' . $this->config['erpfeed-database-connection'] . '.database');

        $mode = $this->option('mode');
        $name = Config::get('database.connections.' . $this->config["$mode-database-connection"] . '.database');
        try {
            $connection = DB::connection($this->config["$mode-database-connection"]);
            $current_definition = $connection->table('datamanager_metadata')
                ->where('metadata_type', '=', 'definition')
                ->where('metadata_key', '=', 'definition')
                ->value('longtext_value');
            $current_definition = json_decode($current_definition, true);
        } catch (Exception $e) {
            $current_definition = false;
        }
        $classname = 'Visionware\\DataManager\\' . ucfirst($mode) . 'SchemaManager';
        $creator = new $classname(new MysqlGrammar(), $name, $this->definition, $current_definition);
        $statements = $creator->migrate();
//        if ($this->option('mode') == 'sqlite') {
//            usort($statements, array($this,"sqliteStatementCompare"));
//        }
        if ($this->option('output')) {
            if (!count($statements)) {
                $this->info('No changes are necessary.');
            } else {
                file_put_contents($this->option('output'), implode("\n\n", $statements));
                $this->info('Statements written to file: ' .$this->option('output'));
            }
        } else {
            print implode("\n\n", $statements);
        }
    }

    function sqliteStatementCompare($a, $b) {

        if (strpos($a, "CREATE TABLE") === strpos($b, "CREATE TABLE")) {
            return strcmp($a, $b);
        } else {
            return strpos($a, "CREATE TABLE") < strpos($b, "CREATE TABLE") ? 1 : -1;
        }
    }
}