<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 12:35 PM
 */

namespace Visionware\DataManager\Definition;

use Illuminate\Support\Collection;

class SchemaDefinition extends Definition {
    private $definition;
    private $tables;
    private $views;

    public function __construct() {
        parent::__construct();
        $this->tables = new Collection;
        $this->views = new Collection;
    }

    public static function hydrate($definition) {
        $instance = new static();
        $instance->definition = $definition;
        foreach ($definition['tables'] as $table) {
            $tableDefinition = TableDefinition::hydrate($table);
            $instance->putTable($tableDefinition);
        }
        foreach (array_get($definition, 'views', []) as $view) {
            $viewDefinition = ViewDefinition::hydrate($view);
            $instance->putView($viewDefinition);
        }
        $instance->validate();
        return $instance;
    }

    public function putTable(TableDefinition $table) {
        $table->setSchema($this);
        $this->tables->put($table->name(), $table);
    }

    public function putView(ViewDefinition $view) {
        $view->setSchema($this);
        $this->views->put($view->name(), $view);
    }
    /**
     * @return Collection
     */
    public function tables() {
        return $this->tables;
    }

    public function views() {
        return $this->views;
    }

    public function validate() {
        foreach ($this->tables() as $table) $table->validate();
    }
}