<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 8/5/16
 * Time: 9:29 AM
 */

namespace Visionware\DataManager;

use Illuminate\Database\Connection;
use Monolog\Logger;
use Carbon\Carbon;

abstract class BaseUpdater {

    /**
     * @var Connection
     */
    protected $db;

    /**
     * @var Logger
     */
    protected $logger;

    public function __construct($db, $logger) {
        $this->db = $db;
        $this->logger = $logger;
    }

    abstract public function go();

    protected function queryWithSequence($table, $sql, $bindings = []) {
        $this->logger->info("Attempting to lock and read max commit sequence for $table...");

        $bindings['commit_sequence'] = $this->db->table($table)->lockForUpdate()->max('commit_sequence') + 1;

        $this->query($sql, $bindings);
    }

    protected function query($sqls, $bindings = []) {
        if (!is_array($sqls)) $sqls = [$sqls];
        foreach ($sqls as $desc => $sql) {
            $this->logger->info("[$desc] Executing statement...");
            $this->logger->debug($sql, $bindings);
            $qStart = Carbon::now();
            $count = $this->db->affectingStatement($sql, $bindings);
            $qDiff = Carbon::now()->diffForHumans($qStart, true);
            $this->logger->notice("[$desc] Affected $count rows in $qDiff total");
        }
    }
}