<?php

namespace Visionware\DataManager\Actions;

use Closure;
use Illuminate\Support\Collection;
use Visionware\DataManager\Definition\Definition;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\ColumnInfo;
use Visionware\DataManager\Info\IndexInfo;
use Visionware\DataManager\Info\Info;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;
use Visionware\DataManager\Info\ViewInfo;

/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/21/16
 * Time: 10:14 AM
 * @method viewFromTable(Closure $callback) Prepend a column to the table. Callback arguments: TableDefinition, TableInfo. Callback should return ViewInfo or a Collection of ViewInfos
 */
class TableViewAction extends Action {
    protected $allowedOperations = [
        'viewFromTable',
    ];

    protected function executeViewFromTable(ViewInfo $viewInfo, TableInfo $tableInfo) {
        $tableInfo->schema()->putView($viewInfo);
        return $tableInfo;
    }
}