<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 2/29/16
 * Time: 10:39 AM
 */

namespace Visionware\DataManager\Console\Commands;

use Carbon\Carbon;
use DB;
use Illuminate\Console\Command;
use Illuminate\Database\Connection;
use Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use DataManager;
use Symfony\Bridge\Monolog\Handler\ConsoleHandler;
use Symfony\Component\Console\Output\OutputInterface;
use Visionware\DataManager\Schema\ImporterSchemaInfo;
use Visionware\DataManager\Schema\SchemaInfo;

class SyncTestCommand extends Command {
    protected $signature = 'datamanager:synctest {date}';

    protected $description = 'How many records will I sync?';

    public function handle() {
        /** @var Connection $db */
        $db = DataManager::getConnectionForMode('live');
        $schema = DataManager::getSchemaInfo('live');
        $this->info('Gathering data...');
        $myDate = $db->getPdo()->quote($this->argument('date'));
        $rows = [];
        $tables = $schema->tables();
        $bar = $this->output->createProgressBar(count($tables));
        $bar->setFormat(' %current%/%max% [%bar%] %percent:3s%% %message%');
        $bar->setMessage('');
        $bar->start();
        foreach ($tables as $table) {
            try {
                if (is_null($table->definition()) || !$table->definition()->isSyncedDown()) continue;
                $bar->setMessage($table->name() . '                         ');
                $results = $db->select(DB::raw("SELECT count(distinct id) as theCount FROM $table WHERE date_uploaded > $myDate"));
                foreach ($results as $result) {
                    $rows[] = [$table->name(), $result->theCount];
                }
                $bar->advance();
            } catch (Exception $e) {
                $this->error('Exception caught while checking table.', $e);
            }
        }
        $bar->finish();
        $this->info('');
        $this->info("Records that have changed since $myDate");
        $this->table(['Table', 'Date Modified', 'Rows'], $rows);
    }
}