<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 10:22 AM
 */

namespace Visionware\DataManager\Info;

use Closure;
use Illuminate\Support\Collection;
use Visionware\DataManager\Actions\ActionManager;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Definition\ViewDefinition;
use Visionware\DataManager\Info\SchemaInfo;

class ViewInfo extends Info {
    /**
     * @var SchemaInfo
     */
    private $schema;
    private $name;
    private $statement;

    public function setName($name) {
        $this->name = $name;
    }

    public function setStatement($statement) {
        $this->statement = $statement;
    }

    public function setSchema($schema) {
        $this->schema = $schema;
    }

    public function name() {
        return $this->name;
    }

    public function statement() {
        return $this->statement;
    }

    public function clone() {
        $instance = self::create($this->name(), $this->statement());
        return $instance;
    }

    public function schema() {
        return $this->schema;
    }

    public function compareTo(ViewInfo $compareView) {
        $equal = $this->name() == $compareView->name();
        $equal = $equal && $this->statement() == $compareView->statement();
        return $equal;
    }

    public static function createFromDefinition(ViewDefinition $view) {
        $instance = new static();
        $instance->setName($view->name());
        $instance->setStatement($view->statement());
        return $instance;
    }

    public static function create($name, $statement) {
        $instance = new static();
        $instance->setName($name);
        $instance->setStatement($statement);
        return $instance;
    }

    public function __toString() {
        return "{$this->name()}";
    }

    public function __toDebugArray() {
        return [
            'name' => $this->name(),
            'statement' => $this->statement(),
        ];
    }
}