<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/13/16
 * Time: 11:09 AM
 */

namespace Visionware\DataManager;

use Monolog\Logger;
use Log;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

abstract class DataManagerProcess {
    protected $tableName;
    /**
     * @var TableInfo
     */
    protected $info;
    /**
     * @var TableDefinition
     */
    protected $definition;
    protected $force;
    protected $logger;
    protected $schema;

    public function __construct(SchemaInfo $schema) {
        $this->schema = $schema;
        $this->force = false;
        $this->run_after_completed = false;
        $this->logger = Log::getMonolog();
    }

    abstract public function go();

    public function setTable(string $tableName) {
        $this->info = $this->schema->tables()->get($tableName);
        $this->definition = $this->info->definition();
        $this->tableName = $tableName;
        return $this;
    }

    public function force($val = false) {
        $this->force = $val;
        return $this;
    }

    public function logger(Logger $logger) {
        $this->logger = $logger;
        return $this;
    }

    function __call($name, $arguments) {
        if (in_array($name, ['emergency', 'alert', 'critical', 'error', 'warn', 'notice', 'info', 'debug'])) {
            call_user_func_array([$this->logger, $name], $arguments);
            $arguments[1] = array_merge(isset($arguments[1]) ? $arguments[1] : [], ['datamanager-table' => $this->tableName]);
            $logger = Log::getMonolog();

            return call_user_func_array([$logger, $name], $arguments);
//        } else if (starts_with($name, 'table_')) {
//            $schema_method = preg_replace('/table_/', '', $name, 1);
//            if (method_exists($this->schema, $schema_method)) {
//                array_unshift($arguments, $this->table_name);
//                return call_user_func_array([$this->schema, $schema_method], $arguments);
//            }
        } else if (method_exists($this, $name)) {
            return call_user_func_array([$this, $name], $arguments);
        }
        trigger_error("Call to unhandled __call function $name()", E_USER_ERROR);
    }
}