<?php

namespace Visionware\DataManager\Actions;

use Illuminate\Support\Collection;
use Visionware\DataManager\Definition\SchemaDefinition;
use Visionware\DataManager\Definition\TableDefinition;
use Visionware\DataManager\Info\Info;
use Visionware\DataManager\Info\SchemaInfo;
use Visionware\DataManager\Info\TableInfo;

/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/21/16
 * Time: 10:14 AM
 */
class ActionManager {
    private $schemaActions;
    private $tableActions;
    private $columnActions;
    private $indexActions;

    public function __construct() {
        $this->schemaActions = new Collection;
        $this->tableActions = new Collection;
        $this->columnActions = new Collection;
        $this->indexActions = new Collection;
    }

    /**
     * @return SchemaAction
     */
    public function schema() {
        $action = new SchemaAction;
        $this->schemaActions->push($action);
        return $action;
    }

    /**
     * @return TableAction
     */
    public function table() {
        $action = new TableAction;
        $this->tableActions->push($action);
        return $action;
    }
    
    /**
     * @return ColumnAction
     */
    public function column() {
        $action = new ColumnAction;
        $this->columnActions->push($action);
        return $action;
    }

    public function executeSchema(SchemaDefinition $schemaDefinition, SchemaInfo $schemaInfo) {
        foreach ($this->schemaActions as $action) {
            $schemaInfo = $action->execute($schemaDefinition, $schemaInfo);
        }
//        return $schemaInfo;
    }

    public function executeTable(TableDefinition $tableDefinition, TableInfo $tableInfo) {
        foreach ($this->tableActions as $action) {
            if (!$tableInfo->isDerived()) {
                $tableInfo = $action->execute($tableDefinition, $tableInfo);
            }
        }
//        return $tableInfo;
    }
}