<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 5/20/16
 * Time: 12:43 PM
 */

namespace Visionware\DataManager\Definition;

use Illuminate\Support\Collection;

class IndexDefinition extends Definition {
    /**
     * @var string
     */
    private $type;
    /**
     * @var array
     */
    private $columns;

    public function setType($type) {
        $this->type = $type;
    }

    public function setColumns($columns) {
        if (!is_array($columns)) trigger_error("Columns must be an array of strings");
        $this->columns = $columns;
    }

    public function setName($name) {
        $this->putOther('name', $name);
    }

    public function setTable($table) {
        $this->table = $table;
    }

    public function name() {
        $givenName = $this->getOther('name');
        if (!is_null($givenName)) return $givenName;
        return implode('-', $this->columns);
    }
    
    public function type() {
        return $this->type;
    }

    public function columns() {
        return $this->columns;
    }

    public static function hydrate($array) {
        $instance = new static();
        $instance->setType($array['type']);
        $instance->setColumns($array['columns']);
        $instance->setOther(collect(array_except($array, ['type', 'columns'])));
        return $instance;
    }

    public function validate() {

    }
}