<?php

namespace Visionware\DataManager\Console\Commands;

use Config;
use DB;
use Storage;
use Visionware\DataManager\HistorySchemaCreator;
use Visionware\DataManager\SqliteSchemaCreator;
use Visionware\DataManager\LiveStagingSchemaCreator;
use Visionware\DataManager\LiveSchemaCreator;

class CreateSchema extends DataManagerCommand {
    protected $datamanager_command_name = 'datamanager:create';
    protected $datamanager_signature = '
            {--output= : Output to a file instead of executing. Required if using sqlite mode.}
            {--mode= : Creation mode history, live, sqlite, api }
            {--execute : Execute the SQL statements instead of printing them to standard out. DESTRUCTIVE!}
            {--drop : Drops tables before creating them}
    ';

    protected $description = 'Builds create statements';

    protected function datamanager_handle() {
        if ($this->option('mode') == 'sqlite' && is_null($this->option('output'))) {
            $this->error("You must specify an output file when using SQLite mode!");
            return false;
        }


        $schema = json_decode(Storage::disk($this->config['disk'])->get($this->config['path']), true );
        $history_db_name = Config::get('database.connections.' . $this->config['history-database-connection'] . '.database');
        $live_db_name = Config::get('database.connections.' . $this->config['live-database-connection'] . '.database');
        if ($this->option('mode') == 'history') $creator = new HistorySchemaCreator($schema, $this->option('drop'), $history_db_name);
//        else if ($this->option('mode') == 'live-staging') $creator = new LiveStagingSchemaCreator($schema, $this->option('drop'), $live_db_name);
        else if ($this->option('mode') == 'live') $creator = new LiveSchemaCreator($schema, $this->option('drop'), $live_db_name);
        else if ($this->option('mode') == 'sqlite') $creator = new SqliteSchemaCreator($schema, $this->option('drop'), $live_db_name);
        $statements = $creator->build_schema();

        if ($this->option('mode') == 'sqlite') {
            usort($statements, array($this,"sqliteStatementCompare"));
        }
        if ($this->option('output')) {
            file_put_contents($this->option('output'), implode("\n\n", $statements));
            $this->info('Statements written to file: ' .$this->option('output'));
//        } else {
//            $db = null;
//            if ($this->option('mode' == 'history')) $db = DB::connection($this->config['history-database-connection']);
//            foreach ($statements as $statement) $db->statement($statement);
        }
    }

    function sqliteStatementCompare($a, $b) {

        if (strpos($a, "CREATE TABLE") === strpos($b, "CREATE TABLE")) {
            return strcmp($a, $b);
        } else {
            return strpos($a, "CREATE TABLE") < strpos($b, "CREATE TABLE") ? 1 : -1;
        }
    }
}